package mcfall.raytracer.tests;

import java.awt.Dimension;
import java.util.List;

import mcfall.math.Matrix;
import mcfall.math.Point;
import mcfall.math.Ray;
import mcfall.raytracer.Camera;
import mcfall.raytracer.Material;
import mcfall.raytracer.ThreeDimensionalObject;
import mcfall.raytracer.objects.GenericPlane;
import mcfall.raytracer.objects.GenericSphere;
import mcfall.raytracer.objects.HitRecord;

public class Scene extends TestCase {

	mcfall.raytracer.Scene scene, sceneFromFile;
	ThreeDimensionalObject sphere1, sphere2, plane;
	Camera camera;
	
	protected void setUp() throws Exception {
		scene = new mcfall.raytracer.Scene ();
		sphere1 = new GenericSphere ();
		sphere2 = new GenericSphere ();
		sphere2.transform(Matrix.createScalingMatrix(1.5, 1, 1));
		
		plane = new GenericPlane ();
		camera = new Camera (new Point (2, 0, 0), new Point (0, 0, 0), 90, 1.0, 1, new java.awt.Dimension (600, 600));
		scene.addObject(sphere1);
		scene.addObject(plane);
		scene.addObject(sphere2);
		
		sceneFromFile = new mcfall.raytracer.Scene ("SimpleScene.xml");
	}

	/*
	 * Test method for 'mcfall.raytracer.Scene.firstObjectHitBy(Ray)'
	 */
	public void testFirstObjectHitBy() {
		Ray throughMiddle = camera.rayThrough(300, 300);
		HitRecord hitRecord = scene.firstObjectHitBy(throughMiddle);
		assertSame(sphere2, hitRecord.object);
		
		//  Now try a camera that starts "inside" the bigger sphere, and make sure it hits the smaller one first
		camera = new Camera (new Point (1, 0, 0), new Point(0, 0, 0), 90, 1.0, 1, new Dimension(600, 600));
		throughMiddle = camera.rayThrough(300, 300);
		hitRecord = scene.firstObjectHitBy(throughMiddle);
		assertSame(sphere1, hitRecord.object);
	}
	
	public void testSceneFile () throws Exception {
		
		assertEquals (2, sceneFromFile.getLights().size());
		
		assertEquals(3, sceneFromFile.getObjectList().size());
		assertTrue (sceneFromFile.getObjectList().get(0).getClass() == GenericSphere.class);
		
		
	}
	
	public void testReferencedMaterial () throws Exception {
		List<ThreeDimensionalObject> objectList = sceneFromFile.getObjectList();
		
		for (ThreeDimensionalObject object : objectList) {
			if (object.getName().equals("Sphere1")) {
				Material material = object.getMaterial();
				assertEquals (1.0, material.getDiffuse().getRed());
				assertEquals (0.9, material.getDiffuse().getGreen());
				assertEquals (0.8, material.getDiffuse().getBlue());
				
				assertEquals (0.7, material.getAmbient().getRed());
				assertEquals (0.6, material.getAmbient().getGreen());
				assertEquals (0.5, material.getAmbient().getBlue());
				
				assertEquals (0.4, material.getSpecular().getRed());
				assertEquals (0.3, material.getSpecular().getGreen());
				assertEquals (0.2, material.getSpecular().getBlue());
			}
		}
	}

	public void testInlineMaterial () throws Exception {
		List<ThreeDimensionalObject> objectList = sceneFromFile.getObjectList();
		for (ThreeDimensionalObject object : objectList) {
			if (object.getName().equals("Sphere2")) {
				Material material = object.getMaterial();
				assertEquals (0.1, material.getDiffuse().getRed());
				assertEquals (0.2, material.getDiffuse().getGreen());
				assertEquals (0.3, material.getDiffuse().getBlue());
				
				assertEquals (0.4, material.getAmbient().getRed());
				assertEquals (0.5, material.getAmbient().getGreen());
				assertEquals (0.6, material.getAmbient().getBlue());
				
				assertEquals (0.7, material.getSpecular().getRed());
				assertEquals (0.8, material.getSpecular().getGreen());
				assertEquals (0.9, material.getSpecular().getBlue());
			}
		}
	}
}
